#ifndef BITCOINEXCHANGE_HPP
#define BITCOINEXCHANGE_HPP

#include <string>
#include <map>
#include <fstream>
#include <iostream>
#include <sstream>
#include <cstdlib>

class BitcoinExchange {
private:
    std::map<std::string, float> _database;

    BitcoinExchange(const BitcoinExchange& other);
    BitcoinExchange& operator=(const BitcoinExchange& other);

    bool isValidDate(const std::string& date) const;
    bool isLeapYear(int year) const;
    int getDaysInMonth(int year, int month) const;
    float getExchangeRate(const std::string& date) const;
    std::string trim(const std::string& str) const;

public:
    BitcoinExchange();
    ~BitcoinExchange();

    bool loadDatabase(const std::string& filename);
    void processInput(const std::string& filename);
};

#endif
