/* ************************************************************************** */
/*                                                                            */
/*                                                        :::      ::::::::   */
/*   main.cpp                                           :+:      :+:    :+:   */
/*                                                    +:+ +:+         +:+     */
/*   By: student <student@42.fr>                    +#+  +:+       +#+        */
/*                                                +#+#+#+#+#+   +#+           */
/*   Created: 2024/01/01 00:00:00 by student           #+#    #+#             */
/*   Updated: 2024/01/01 00:00:00 by student          ###   ########.fr       */
/*                                                                            */
/* ************************************************************************** */

#include "MutantStack.hpp"
#include <iostream>
#include <list>

int main()
{
	std::cout << "=== Subject Test with MutantStack ===" << std::endl;
	{
		MutantStack<int> mstack;

		mstack.push(5);
		mstack.push(17);

		std::cout << mstack.top() << std::endl;

		mstack.pop();

		std::cout << mstack.size() << std::endl;

		mstack.push(3);
		mstack.push(5);
		mstack.push(737);
		mstack.push(0);

		MutantStack<int>::iterator it = mstack.begin();
		MutantStack<int>::iterator ite = mstack.end();

		++it;
		--it;
		while (it != ite)
		{
			std::cout << *it << std::endl;
			++it;
		}
		std::stack<int> s(mstack);
	}

	std::cout << std::endl << "=== Same Test with std::list ===" << std::endl;
	{
		std::list<int> lst;

		lst.push_back(5);
		lst.push_back(17);

		std::cout << lst.back() << std::endl;

		lst.pop_back();

		std::cout << lst.size() << std::endl;

		lst.push_back(3);
		lst.push_back(5);
		lst.push_back(737);
		lst.push_back(0);

		std::list<int>::iterator it = lst.begin();
		std::list<int>::iterator ite = lst.end();

		++it;
		--it;
		while (it != ite)
		{
			std::cout << *it << std::endl;
			++it;
		}
	}

	std::cout << std::endl << "=== Additional Tests ===" << std::endl;
	{
		MutantStack<int> mstack;
		for (int i = 0; i < 10; ++i)
			mstack.push(i * 10);

		std::cout << "Forward iteration: ";
		for (MutantStack<int>::iterator it = mstack.begin(); it != mstack.end(); ++it)
			std::cout << *it << " ";
		std::cout << std::endl;

		std::cout << "Reverse iteration: ";
		for (MutantStack<int>::reverse_iterator rit = mstack.rbegin(); rit != mstack.rend(); ++rit)
			std::cout << *rit << " ";
		std::cout << std::endl;
	}

	std::cout << std::endl << "=== Const Iterator Test ===" << std::endl;
	{
		MutantStack<int> mstack;
		mstack.push(42);
		mstack.push(21);
		mstack.push(84);

		const MutantStack<int>& constRef = mstack;
		std::cout << "Const iteration: ";
		for (MutantStack<int>::const_iterator it = constRef.begin(); it != constRef.end(); ++it)
			std::cout << *it << " ";
		std::cout << std::endl;
	}

	std::cout << std::endl << "=== Copy Test ===" << std::endl;
	{
		MutantStack<int> original;
		original.push(1);
		original.push(2);
		original.push(3);

		MutantStack<int> copy(original);
		MutantStack<int> assigned;
		assigned = original;

		original.pop();

		std::cout << "Original (after pop): ";
		for (MutantStack<int>::iterator it = original.begin(); it != original.end(); ++it)
			std::cout << *it << " ";
		std::cout << std::endl;

		std::cout << "Copy: ";
		for (MutantStack<int>::iterator it = copy.begin(); it != copy.end(); ++it)
			std::cout << *it << " ";
		std::cout << std::endl;

		std::cout << "Assigned: ";
		for (MutantStack<int>::iterator it = assigned.begin(); it != assigned.end(); ++it)
			std::cout << *it << " ";
		std::cout << std::endl;
	}

	std::cout << std::endl << "=== String Stack Test ===" << std::endl;
	{
		MutantStack<std::string> strStack;
		strStack.push("Hello");
		strStack.push("World");
		strStack.push("42");

		for (MutantStack<std::string>::iterator it = strStack.begin(); it != strStack.end(); ++it)
			std::cout << *it << " ";
		std::cout << std::endl;
	}

	return 0;
}
