/* ************************************************************************** */
/*                                                                            */
/*                                                        :::      ::::::::   */
/*   main.cpp                                           :+:      :+:    :+:   */
/*                                                    +:+ +:+         +:+     */
/*   By: tutor <tutor@student.42.fr>                +#+  +:+       +#+        */
/*                                                +#+#+#+#+#+   +#+           */
/*   Created: 2024/01/01 00:00:00 by tutor             #+#    #+#             */
/*   Updated: 2024/01/01 00:00:00 by tutor            ###   ########.fr       */
/*                                                                            */
/* ************************************************************************** */

#include <iostream>
#include <string>
#include "iter.hpp"

template<typename T>
void printElement(T const& elem)
{
	std::cout << elem << " ";
}

void incrementInt(int& n)
{
	n++;
}

void toUpperCase(std::string& str)
{
	for (std::size_t i = 0; i < str.length(); i++)
	{
		if (str[i] >= 'a' && str[i] <= 'z')
			str[i] = str[i] - 32;
	}
}

int main(void)
{
	std::cout << "=== Test with int array ===" << std::endl;
	int intArray[] = {1, 2, 3, 4, 5};
	std::size_t intLen = sizeof(intArray) / sizeof(intArray[0]);

	std::cout << "Original: ";
	iter(intArray, intLen, printElement<int>);
	std::cout << std::endl;

	iter(intArray, intLen, incrementInt);
	std::cout << "After increment: ";
	iter(intArray, intLen, printElement<int>);
	std::cout << std::endl;

	std::cout << std::endl << "=== Test with string array ===" << std::endl;
	std::string strArray[] = {"hello", "world", "forty", "two"};
	std::size_t strLen = sizeof(strArray) / sizeof(strArray[0]);

	std::cout << "Original: ";
	iter(strArray, strLen, printElement<std::string>);
	std::cout << std::endl;

	iter(strArray, strLen, toUpperCase);
	std::cout << "After toUpperCase: ";
	iter(strArray, strLen, printElement<std::string>);
	std::cout << std::endl;

	std::cout << std::endl << "=== Test with double array ===" << std::endl;
	double doubleArray[] = {1.1, 2.2, 3.3, 4.4, 5.5};
	std::size_t doubleLen = sizeof(doubleArray) / sizeof(doubleArray[0]);

	std::cout << "Double array: ";
	iter(doubleArray, doubleLen, printElement<double>);
	std::cout << std::endl;

	std::cout << std::endl << "=== Test with char array ===" << std::endl;
	char charArray[] = {'a', 'b', 'c', 'd', 'e'};
	std::size_t charLen = sizeof(charArray) / sizeof(charArray[0]);

	std::cout << "Char array: ";
	iter(charArray, charLen, printElement<char>);
	std::cout << std::endl;

	return 0;
}
