#include <iostream>
#include "Serializer.hpp"

int main()
{
	Data original;
	original.id = 42;
	original.name = "Test Data";
	original.value = 3.14159;

	std::cout << "=== Original Data ===" << std::endl;
	std::cout << "Address: " << &original << std::endl;
	std::cout << "id: " << original.id << std::endl;
	std::cout << "name: " << original.name << std::endl;
	std::cout << "value: " << original.value << std::endl;

	uintptr_t serialized = Serializer::serialize(&original);
	std::cout << std::endl << "=== Serialized ===" << std::endl;
	std::cout << "Raw value: " << serialized << std::endl;

	Data* deserialized = Serializer::deserialize(serialized);
	std::cout << std::endl << "=== Deserialized Data ===" << std::endl;
	std::cout << "Address: " << deserialized << std::endl;
	std::cout << "id: " << deserialized->id << std::endl;
	std::cout << "name: " << deserialized->name << std::endl;
	std::cout << "value: " << deserialized->value << std::endl;

	std::cout << std::endl << "=== Verification ===" << std::endl;
	if (deserialized == &original)
		std::cout << "SUCCESS: Pointers are equal!" << std::endl;
	else
		std::cout << "FAILURE: Pointers are NOT equal!" << std::endl;

	return 0;
}
