#include "Bureaucrat.hpp"
#include "AForm.hpp"
#include "ShrubberyCreationForm.hpp"
#include "RobotomyRequestForm.hpp"
#include "PresidentialPardonForm.hpp"
#include <iostream>
#include <cstdlib>
#include <ctime>

int main() {
	std::srand(std::time(NULL));

	std::cout << "=== Test 1: ShrubberyCreationForm ===" << std::endl;
	try {
		Bureaucrat gardener("Gardener", 130);
		ShrubberyCreationForm shrub("home");
		
		std::cout << gardener << std::endl;
		std::cout << shrub << std::endl;
		
		gardener.signForm(shrub);
		gardener.executeForm(shrub);
	} catch (std::exception& e) {
		std::cout << "Exception: " << e.what() << std::endl;
	}

	std::cout << "\n=== Test 2: RobotomyRequestForm ===" << std::endl;
	try {
		Bureaucrat engineer("Engineer", 40);
		RobotomyRequestForm robot("Bender");
		
		std::cout << engineer << std::endl;
		std::cout << robot << std::endl;
		
		engineer.signForm(robot);
		engineer.executeForm(robot);
		engineer.executeForm(robot);
		engineer.executeForm(robot);
	} catch (std::exception& e) {
		std::cout << "Exception: " << e.what() << std::endl;
	}

	std::cout << "\n=== Test 3: PresidentialPardonForm ===" << std::endl;
	try {
		Bureaucrat president("President", 1);
		PresidentialPardonForm pardon("Arthur Dent");
		
		std::cout << president << std::endl;
		std::cout << pardon << std::endl;
		
		president.signForm(pardon);
		president.executeForm(pardon);
	} catch (std::exception& e) {
		std::cout << "Exception: " << e.what() << std::endl;
	}

	std::cout << "\n=== Test 4: Execute unsigned form ===" << std::endl;
	try {
		Bureaucrat boss("Boss", 1);
		PresidentialPardonForm pardon("Ford Prefect");
		
		std::cout << pardon << std::endl;
		boss.executeForm(pardon);
	} catch (std::exception& e) {
		std::cout << "Exception: " << e.what() << std::endl;
	}

	std::cout << "\n=== Test 5: Grade too low to execute ===" << std::endl;
	try {
		Bureaucrat intern("Intern", 100);
		Bureaucrat boss("Boss", 1);
		RobotomyRequestForm robot("Marvin");
		
		boss.signForm(robot);
		std::cout << robot << std::endl;
		intern.executeForm(robot);
	} catch (std::exception& e) {
		std::cout << "Exception: " << e.what() << std::endl;
	}

	std::cout << "\n=== Test 6: Grade too low to sign ===" << std::endl;
	try {
		Bureaucrat lowGrade("LowGrade", 150);
		ShrubberyCreationForm shrub("garden");
		
		lowGrade.signForm(shrub);
	} catch (std::exception& e) {
		std::cout << "Exception: " << e.what() << std::endl;
	}

	return 0;
}
