#include "Bureaucrat.hpp"
#include "Form.hpp"
#include <iostream>

int main() {
	std::cout << "=== Test 1: Create valid form ===" << std::endl;
	try {
		Form taxForm("Tax Form", 50, 25);
		std::cout << taxForm << std::endl;
	} catch (std::exception& e) {
		std::cout << "Exception: " << e.what() << std::endl;
	}

	std::cout << "\n=== Test 2: Form with invalid grade (too high) ===" << std::endl;
	try {
		Form invalid("Invalid", 0, 25);
		std::cout << invalid << std::endl;
	} catch (std::exception& e) {
		std::cout << "Exception: " << e.what() << std::endl;
	}

	std::cout << "\n=== Test 3: Form with invalid grade (too low) ===" << std::endl;
	try {
		Form invalid("Invalid", 50, 151);
		std::cout << invalid << std::endl;
	} catch (std::exception& e) {
		std::cout << "Exception: " << e.what() << std::endl;
	}

	std::cout << "\n=== Test 4: Bureaucrat signs form (success) ===" << std::endl;
	try {
		Bureaucrat boss("Boss", 10);
		Form contract("Contract", 50, 25);
		std::cout << boss << std::endl;
		std::cout << contract << std::endl;
		boss.signForm(contract);
		std::cout << contract << std::endl;
	} catch (std::exception& e) {
		std::cout << "Exception: " << e.what() << std::endl;
	}

	std::cout << "\n=== Test 5: Bureaucrat signs form (failure - grade too low) ===" << std::endl;
	try {
		Bureaucrat intern("Intern", 100);
		Form topSecret("Top Secret", 10, 5);
		std::cout << intern << std::endl;
		std::cout << topSecret << std::endl;
		intern.signForm(topSecret);
		std::cout << topSecret << std::endl;
	} catch (std::exception& e) {
		std::cout << "Exception: " << e.what() << std::endl;
	}

	std::cout << "\n=== Test 6: Multiple bureaucrats, one form ===" << std::endl;
	try {
		Bureaucrat junior("Junior", 100);
		Bureaucrat senior("Senior", 20);
		Form report("Annual Report", 50, 30);
		
		std::cout << junior << std::endl;
		std::cout << senior << std::endl;
		std::cout << report << std::endl;
		
		junior.signForm(report);
		std::cout << report << std::endl;
		
		senior.signForm(report);
		std::cout << report << std::endl;
	} catch (std::exception& e) {
		std::cout << "Exception: " << e.what() << std::endl;
	}

	return 0;
}
