#include "AMateria.hpp"
#include "Ice.hpp"
#include "Cure.hpp"
#include "ICharacter.hpp"
#include "Character.hpp"
#include "IMateriaSource.hpp"
#include "MateriaSource.hpp"

int main() {
    std::cout << "=== Subject Test ===" << std::endl;
    std::cout << std::endl;

    IMateriaSource* src = new MateriaSource();
    src->learnMateria(new Ice());
    src->learnMateria(new Cure());

    ICharacter* me = new Character("me");

    AMateria* tmp;
    tmp = src->createMateria("ice");
    me->equip(tmp);
    tmp = src->createMateria("cure");
    me->equip(tmp);

    ICharacter* bob = new Character("bob");

    me->use(0, *bob);
    me->use(1, *bob);

    delete bob;
    delete me;
    delete src;

    std::cout << std::endl;
    std::cout << "=== Extended Tests ===" << std::endl;
    std::cout << std::endl;

    std::cout << "--- MateriaSource Test ---" << std::endl;
    MateriaSource* source = new MateriaSource();
    source->learnMateria(new Ice());
    source->learnMateria(new Cure());
    source->learnMateria(new Ice());
    source->learnMateria(new Cure());
    source->learnMateria(new Ice());

    AMateria* ice = source->createMateria("ice");
    AMateria* cure = source->createMateria("cure");
    AMateria* unknown = source->createMateria("fire");

    std::cout << "Created ice: " << (ice ? ice->getType() : "null") << std::endl;
    std::cout << "Created cure: " << (cure ? cure->getType() : "null") << std::endl;
    std::cout << "Created fire: " << (unknown ? unknown->getType() : "null") << std::endl;

    delete ice;
    delete cure;
    delete source;

    std::cout << std::endl;
    std::cout << "--- Character Inventory Test ---" << std::endl;
    Character* cloud = new Character("Cloud");

    cloud->equip(new Ice());
    cloud->equip(new Cure());
    cloud->equip(new Ice());
    cloud->equip(new Cure());

    Character* sephiroth = new Character("Sephiroth");

    std::cout << "Cloud uses all materias on Sephiroth:" << std::endl;
    cloud->use(0, *sephiroth);
    cloud->use(1, *sephiroth);
    cloud->use(2, *sephiroth);
    cloud->use(3, *sephiroth);

    std::cout << std::endl;
    std::cout << "--- Unequip Test (no memory leak) ---" << std::endl;
    cloud->unequip(0);
    cloud->unequip(1);
    std::cout << "Unequipped slots 0 and 1" << std::endl;

    std::cout << "Cloud uses slot 0 (should do nothing): ";
    cloud->use(0, *sephiroth);
    std::cout << "(nothing)" << std::endl;

    std::cout << std::endl;
    std::cout << "--- Deep Copy Test ---" << std::endl;
    Character* cloudCopy = new Character(*cloud);
    std::cout << "Created copy of Cloud" << std::endl;

    std::cout << "Original Cloud uses slot 2: ";
    cloud->use(2, *sephiroth);
    std::cout << "Copy of Cloud uses slot 2: ";
    cloudCopy->use(2, *sephiroth);

    delete cloudCopy;
    delete sephiroth;
    delete cloud;

    std::cout << std::endl;
    std::cout << "--- Assignment Operator Test ---" << std::endl;
    Character tifa("Tifa");
    tifa.equip(new Ice());

    Character aerith("Aerith");
    aerith.equip(new Cure());
    aerith.equip(new Cure());

    Character target("Target");

    std::cout << "Tifa before assignment: ";
    tifa.use(0, target);

    tifa = aerith;
    std::cout << "Tifa after assignment (should have Cure): ";
    tifa.use(0, target);
    tifa.use(1, target);

    std::cout << std::endl;
    std::cout << "=== All tests completed ===" << std::endl;

    return 0;
}
