#include <iostream>
#include <fstream>
#include <string>

std::string replaceAll(const std::string& str, const std::string& from, const std::string& to) {
    if (from.empty())
        return str;
    
    std::string result;
    size_t pos = 0;
    size_t lastPos = 0;
    
    while ((pos = str.find(from, lastPos)) != std::string::npos) {
        result += str.substr(lastPos, pos - lastPos);
        result += to;
        lastPos = pos + from.length();
    }
    result += str.substr(lastPos);
    
    return result;
}

int main(int argc, char** argv) {
    if (argc != 4) {
        std::cerr << "Usage: " << argv[0] << " <filename> <s1> <s2>" << std::endl;
        return 1;
    }

    std::string filename = argv[1];
    std::string s1 = argv[2];
    std::string s2 = argv[3];

    if (s1.empty()) {
        std::cerr << "Error: s1 cannot be empty" << std::endl;
        return 1;
    }

    std::ifstream inFile(filename.c_str());
    if (!inFile.is_open()) {
        std::cerr << "Error: cannot open file " << filename << std::endl;
        return 1;
    }

    std::string content;
    std::string line;
    while (std::getline(inFile, line)) {
        content += line;
        if (!inFile.eof())
            content += "\n";
    }
    inFile.close();

    content = replaceAll(content, s1, s2);

    std::ofstream outFile((filename + ".replace").c_str());
    if (!outFile.is_open()) {
        std::cerr << "Error: cannot create output file" << std::endl;
        return 1;
    }

    outFile << content;
    outFile.close();

    return 0;
}
