#ifndef PHONEBOOK_HPP
#define PHONEBOOK_HPP

#include "Contact.hpp"
#include <string>

class PhoneBook {
private:
    Contact     _contacts[8];
    int         _currentIndex;
    int         _totalContacts;

    std::string _truncate(const std::string& str) const;
    void        _displayContactRow(int index) const;
    std::string _getInput(const std::string& prompt) const;

public:
    PhoneBook();
    ~PhoneBook();

    void        addContact();
    void        searchContacts() const;
};

#endif
