/* ************************************************************************** */
/*                                                                            */
/*   SOLUTION: ex00 - Megaphone                                               */
/*                                                                            */
/*   This exercise teaches:                                                   */
/*   - Basic I/O with std::cout (instead of printf)                          */
/*   - Command-line argument handling (argc, argv)                           */
/*   - String iteration and character manipulation                           */
/*   - The toupper() function for case conversion                            */
/*                                                                            */
/* ************************************************************************** */

#include <iostream>  // For std::cout
#include <cctype>    // For toupper()

/*
** Key concepts:
** 
** 1. std::cout << "text" << value << std::endl;
**    - This is the C++ way to output (not printf!)
**    - << is the insertion operator
**    - std::endl outputs newline AND flushes buffer
**
** 2. toupper(c) returns uppercase version of character
**    - Returns int, not char (historical C reasons)
**    - Works on single characters, not strings
**
** 3. Command-line args:
**    - argc = argument count (including program name)
**    - argv[0] = program name
**    - argv[1] to argv[argc-1] = actual arguments
*/

int main(int argc, char **argv)
{
    // Case 1: No arguments provided
    // According to the subject, print the feedback noise message
    if (argc == 1)
    {
        std::cout << "* LOUD AND UNBEARABLE FEEDBACK NOISE *" << std::endl;
        return 0;
    }

    // Case 2: One or more arguments provided
    // Loop through each argument (skip argv[0] which is program name)
    for (int i = 1; i < argc; i++)
    {
        // Loop through each character in the current argument
        for (int j = 0; argv[i][j]; j++)
        {
            // Convert to uppercase and output
            // Note: toupper() returns int, but cout handles the conversion
            std::cout << (char)toupper(argv[i][j]);
        }
        // Note: No space between arguments (check subject examples)
    }

    // Always end with newline (42 requirement)
    std::cout << std::endl;

    return 0;
}

/*
** COMPILATION:
** c++ -Wall -Wextra -Werror -std=c++98 megaphone.cpp -o megaphone
**
** TEST CASES:
** ./megaphone "shhhhh... I think the students are asleep..."
** Expected: SHHHHH... I THINK THE STUDENTS ARE ASLEEP...
**
** ./megaphone Damnit " ! " "Sorry students, I thought this thing was off."
** Expected: DAMNIT ! SORRY STUDENTS, I THOUGHT THIS THING WAS OFF.
**
** ./megaphone
** Expected: * LOUD AND UNBEARABLE FEEDBACK NOISE *
**
** ./megaphone "" ""
** Expected: (empty line - just newline)
**
** COMMON MISTAKES:
** 1. Using printf() instead of std::cout - FORBIDDEN
** 2. Forgetting the no-argument case
** 3. Adding spaces between arguments (don't!)
** 4. Not ending with newline
*/
